<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('produks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('kategori_id')->constrained(
                table: 'kategoris',
                indexName: 'produk_kategori_id'
            )->onDelete('cascade');
            $table->foreignId('satuan_id')->constrained(
                table: 'satuans',
                indexName: 'produk_satuan_id'
            )->onDelete('cascade');
            $table->string('kd_produk')->unique();
            $table->string('nm_produk');
            $table->double('berat');
            $table->double('harga_beli');
            $table->double('harga_jual');
            $table->double('diskon');
            $table->text('ktr_produk');
            $table->text('link_produk');
            $table->text('gambar');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('produks');
    }
};
